# PDPrint - Instalação no cPanel

## 🎯 Guia Completo para Instalação no cPanel

Este guia vai te ajudar a instalar a plataforma PDPrint completa (Admin + E-commerce) no seu cPanel do servidor Napoleon.

---

## 📋 **PRÉ-REQUISITOS:**

✅ **Acesso ao cPanel** do servidor Napoleon
✅ **PHP 7.4+** (recomendado PHP 8.0+)
✅ **MySQL 5.7+** ou **MariaDB 10.2+**
✅ **Extensões PHP:** PDO, PDO_MySQL, GD, mbstring, curl

---

## 🚀 **PASSO A PASSO:**

### **1. FAZER UPLOAD DOS ARQUIVOS**

#### **1.1 Acessar o Gerenciador de Arquivos**
1. Entre no **cPanel**
2. Clique em **"Gerenciador de Arquivos"**
3. Navegue até **"public_html"** (ou pasta do domínio)

#### **1.2 Upload do Sistema**
1. Faça upload do arquivo **`pdprint_cpanel.zip`**
2. **Extraia** o arquivo na pasta public_html
3. **Mova** todos os arquivos da pasta extraída para public_html
4. **Delete** a pasta vazia e o arquivo ZIP

**Estrutura final:**
```
public_html/
├── admin/
├── loja/
├── api/
├── includes/
├── assets/
├── uploads/
├── install.php
├── index.php
├── database.sql
└── outros arquivos...
```

### **2. CRIAR BANCO DE DADOS**

#### **2.1 Acessar MySQL Databases**
1. No cPanel, clique em **"MySQL Databases"**
2. Em **"Create New Database"**, digite: `pdprint_db`
3. Clique em **"Create Database"**

#### **2.2 Criar Usuário do Banco**
1. Em **"MySQL Users"**, crie um usuário:
   - **Username:** `pdprint_user`
   - **Password:** (senha forte)
2. Clique em **"Create User"**

#### **2.3 Associar Usuário ao Banco**
1. Em **"Add User to Database"**
2. Selecione o usuário e o banco criados
3. Marque **"ALL PRIVILEGES"**
4. Clique em **"Make Changes"**

### **3. EXECUTAR INSTALAÇÃO**

#### **3.1 Acessar o Instalador**
1. Abra seu navegador
2. Acesse: **`https://seudominio.com.br/install.php`**

#### **3.2 Configurar Instalação**
Preencha os dados:

**Banco de Dados:**
- **Host:** `localhost`
- **Nome do Banco:** `pdprint_db`
- **Usuário:** `pdprint_user`
- **Senha:** (senha criada no passo 2.2)

**Administrador:**
- **Nome:** Seu nome
- **Email:** seu@email.com
- **Senha:** (senha forte)

**Site:**
- **Nome:** PDPrint
- **URL:** https://seudominio.com.br

#### **3.3 Finalizar Instalação**
1. Clique em **"Instalar PDPrint"**
2. Aguarde a conclusão
3. **Anote** os dados de acesso

---

## 🔧 **CONFIGURAÇÕES ADICIONAIS:**

### **4. CONFIGURAR PERMISSÕES**

#### **4.1 Permissões de Pastas**
No Gerenciador de Arquivos, configure:
- **`uploads/`** → Permissão **755**
- **`includes/`** → Permissão **644**

#### **4.2 Arquivo .htaccess**
Crie o arquivo `.htaccess` na raiz com:
```apache
RewriteEngine On

# Redirecionar para HTTPS
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# Proteger arquivos sensíveis
<Files "*.sql">
    Order allow,deny
    Deny from all
</Files>

<Files "*.log">
    Order allow,deny
    Deny from all
</Files>

# Configurações de segurança
<IfModule mod_headers.c>
    Header always set X-Content-Type-Options nosniff
    Header always set X-Frame-Options DENY
    Header always set X-XSS-Protection "1; mode=block"
</IfModule>
```

### **5. CONFIGURAR EMAIL (OPCIONAL)**

#### **5.1 SMTP no cPanel**
1. Acesse **"Email Accounts"**
2. Crie uma conta: `noreply@seudominio.com.br`
3. Anote as configurações SMTP

#### **5.2 Atualizar Configurações**
Edite `includes/config.php`:
```php
define('SMTP_HOST', 'mail.seudominio.com.br');
define('SMTP_PORT', 587);
define('SMTP_USER', 'noreply@seudominio.com.br');
define('SMTP_PASS', 'senha_do_email');
```

---

## 🎯 **ACESSOS APÓS INSTALAÇÃO:**

### **📊 Painel Administrativo:**
- **URL:** https://seudominio.com.br/admin/
- **Login:** Email configurado na instalação
- **Senha:** Senha configurada na instalação

### **🛍️ Loja Virtual:**
- **URL:** https://seudominio.com.br/loja/
- **Acesso público** para clientes

### **🏠 Página Principal:**
- **URL:** https://seudominio.com.br/
- **Redireciona** automaticamente para a loja

---

## 🔒 **SEGURANÇA IMPORTANTE:**

### **6. APÓS INSTALAÇÃO:**

#### **6.1 Remover Instalador**
```bash
# Delete estes arquivos via Gerenciador:
- install.php
- database.sql
```

#### **6.2 Alterar Senhas**
1. **Acesse o admin** imediatamente
2. **Altere a senha** do administrador
3. **Configure** usuários adicionais se necessário

#### **6.3 Backup Regular**
- Configure **backup automático** no cPanel
- Faça backup do **banco de dados** regularmente

---

## 🆘 **SOLUÇÃO DE PROBLEMAS:**

### **❌ Erro: "Erro de conexão"**
**Solução:**
- Verifique dados do banco de dados
- Confirme se o usuário tem permissões
- Teste conexão no phpMyAdmin

### **❌ Erro: "Página não encontrada"**
**Solução:**
- Verifique se os arquivos estão na pasta correta
- Confirme permissões das pastas
- Verifique .htaccess

### **❌ Erro: "Erro de upload"**
**Solução:**
- Verifique permissões da pasta uploads/
- Aumente limite de upload no PHP
- Verifique espaço em disco

### **❌ Erro: "Erro de email"**
**Solução:**
- Configure SMTP corretamente
- Teste envio via cPanel
- Verifique spam/lixeira

---

## 📞 **SUPORTE:**

### **Logs do Sistema:**
- **Admin:** `/admin/logs.php`
- **Servidor:** cPanel → Error Logs

### **Configurações PHP:**
- **Versão mínima:** PHP 7.4
- **Memory limit:** 256MB (recomendado)
- **Upload limit:** 32MB (recomendado)

---

## 🎉 **PRONTO!**

Sua plataforma PDPrint está instalada e funcionando!

**Próximos passos:**
1. ✅ Cadastrar produtos
2. ✅ Configurar franquias
3. ✅ Personalizar visual
4. ✅ Testar pedidos
5. ✅ Treinar usuários

**🚀 Sua gráfica, malharia e identidade visual agora têm uma plataforma completa e profissional!**

