# PDPrint - Sistema Completo PHP + MySQL

## 🎯 Visão Geral

**PDPrint** é uma plataforma completa e integrada para gestão de gráfica, malharia e identidade visual, desenvolvida em **PHP + MySQL** para funcionar perfeitamente em **cPanel**.

### 🚀 Funcionalidades Principais

#### 📊 **Painel Administrativo**
- ✅ Dashboard com estatísticas em tempo real
- ✅ Gestão completa de produtos e categorias
- ✅ Sistema de pedidos e clientes
- ✅ Controle de estoque por franquia
- ✅ Sistema financeiro (contas a pagar/receber)
- ✅ Gestão de usuários e permissões
- ✅ Sistema de franquias configuráveis
- ✅ Relatórios customizáveis
- ✅ Logs de atividades

#### 🛍️ **E-commerce Integrado**
- ✅ Loja virtual moderna e responsiva
- ✅ Catálogo de produtos com categorias
- ✅ Sistema de carrinho de compras
- ✅ Checkout completo
- ✅ Área do cliente
- ✅ Sistema de cupons de desconto
- ✅ Rastreamento de pedidos
- ✅ SEO otimizado

#### 🔧 **Recursos Técnicos**
- ✅ Arquitetura PHP orientada a objetos
- ✅ Banco de dados MySQL otimizado
- ✅ Sistema de upload de imagens
- ✅ APIs REST para integrações
- ✅ Sistema de logs e auditoria
- ✅ Segurança avançada
- ✅ Design responsivo (mobile-first)

---

## 📋 Requisitos do Sistema

### **Servidor**
- **PHP:** 7.4+ (recomendado 8.0+)
- **MySQL:** 5.7+ ou MariaDB 10.2+
- **Apache:** 2.4+ com mod_rewrite
- **Espaço:** Mínimo 500MB

### **Extensões PHP Necessárias**
- PDO e PDO_MySQL
- GD (manipulação de imagens)
- mbstring (strings multibyte)
- curl (requisições HTTP)
- json (manipulação JSON)
- session (sessões)

### **Configurações Recomendadas**
```ini
memory_limit = 256M
upload_max_filesize = 32M
post_max_size = 32M
max_execution_time = 300
max_input_vars = 3000
```

---

## 🚀 Instalação

### **1. Upload dos Arquivos**
1. Faça upload de todos os arquivos para o diretório público do seu servidor
2. Certifique-se de que a estrutura de pastas está correta

### **2. Configuração do Banco**
1. Crie um banco de dados MySQL
2. Crie um usuário com privilégios completos no banco

### **3. Executar Instalação**
1. Acesse `https://seudominio.com.br/install.php`
2. Preencha os dados do banco e administrador
3. Clique em "Instalar PDPrint"

### **4. Configurações de Segurança**
1. Delete o arquivo `install.php` após a instalação
2. Configure permissões adequadas nas pastas
3. Altere a senha do administrador

---

## 📁 Estrutura do Sistema

```
pdprint/
├── admin/                  # Painel administrativo
│   ├── index.php          # Login admin
│   ├── dashboard.php      # Dashboard principal
│   ├── produtos.php       # Gestão de produtos
│   ├── pedidos.php        # Gestão de pedidos
│   └── ...
├── loja/                   # E-commerce público
│   ├── index.php          # Página inicial
│   ├── produtos.php       # Catálogo
│   ├── carrinho.php       # Carrinho de compras
│   └── ...
├── api/                    # APIs REST
│   ├── produtos.php       # API de produtos
│   ├── pedidos.php        # API de pedidos
│   └── ...
├── includes/               # Arquivos do sistema
│   ├── config.php         # Configurações
│   ├── functions.php      # Funções auxiliares
│   └── classes/           # Classes PHP
├── assets/                 # Recursos estáticos
│   ├── css/               # Estilos CSS
│   ├── js/                # Scripts JavaScript
│   └── images/            # Imagens do sistema
├── uploads/                # Arquivos enviados
├── database.sql           # Estrutura do banco
├── install.php            # Instalador
├── .htaccess             # Configurações Apache
└── README.md             # Este arquivo
```

---

## 🔐 Segurança

### **Medidas Implementadas**
- ✅ Proteção contra SQL Injection (PDO Prepared Statements)
- ✅ Proteção contra XSS (htmlspecialchars)
- ✅ Validação e sanitização de dados
- ✅ Sistema de sessões seguro
- ✅ Hash de senhas (password_hash)
- ✅ Logs de atividades
- ✅ Proteção de arquivos sensíveis (.htaccess)
- ✅ Headers de segurança HTTP

### **Configurações Recomendadas**
1. **SSL/HTTPS:** Configure certificado SSL
2. **Backup:** Configure backup automático
3. **Firewall:** Configure firewall do servidor
4. **Atualizações:** Mantenha PHP e MySQL atualizados

---

## 🎨 Personalização

### **Visual/Design**
- Edite os arquivos CSS em `assets/css/`
- Modifique os templates PHP nas respectivas pastas
- Personalize cores e fontes conforme sua marca

### **Funcionalidades**
- Adicione novos módulos na pasta `admin/`
- Crie novas APIs na pasta `api/`
- Estenda as classes em `includes/classes/`

### **Configurações**
- Modifique `includes/config.php` para configurações gerais
- Use a tabela `configuracoes` para settings dinâmicos

---

## 📊 Banco de Dados

### **Principais Tabelas**
- **usuarios:** Usuários do sistema administrativo
- **clientes:** Clientes da loja virtual
- **produtos:** Catálogo de produtos
- **categorias:** Categorias de produtos
- **pedidos:** Pedidos realizados
- **estoque:** Controle de estoque por franquia
- **franquias:** Gestão de franquias
- **financeiro:** Contas a pagar/receber

### **Relacionamentos**
- Produtos → Categorias (N:1)
- Pedidos → Clientes (N:1)
- Estoque → Produtos + Franquias (N:N)
- Usuários → Franquias (N:1)

---

## 🔧 APIs

### **Endpoints Principais**
```
GET  /api/produtos.php          # Listar produtos
POST /api/produtos.php          # Criar produto
PUT  /api/produtos.php?id=1     # Atualizar produto

GET  /api/pedidos.php           # Listar pedidos
POST /api/pedidos.php           # Criar pedido

GET  /api/clientes.php          # Listar clientes
POST /api/clientes.php          # Criar cliente
```

### **Autenticação**
- Sistema baseado em sessões PHP
- Headers de autorização para APIs
- Tokens JWT para integrações externas

---

## 🆘 Solução de Problemas

### **Problemas Comuns**

#### **Erro de Conexão com Banco**
```
Solução:
1. Verifique credenciais em includes/config.php
2. Confirme se o banco existe
3. Teste conexão via phpMyAdmin
```

#### **Erro de Upload de Arquivos**
```
Solução:
1. Verifique permissões da pasta uploads/ (755)
2. Aumente upload_max_filesize no PHP
3. Verifique espaço em disco
```

#### **Página em Branco**
```
Solução:
1. Ative display_errors no PHP
2. Verifique logs de erro do servidor
3. Confirme se todas as extensões PHP estão instaladas
```

### **Logs do Sistema**
- **PHP Errors:** Logs do servidor web
- **Sistema:** Tabela `logs` no banco de dados
- **Admin:** Painel admin → Logs

---

## 📞 Suporte

### **Documentação**
- `INSTALACAO_CPANEL.md` - Guia de instalação detalhado
- Comentários no código fonte
- Estrutura auto-documentada

### **Manutenção**
- Backup regular do banco de dados
- Limpeza periódica de logs antigos
- Atualização de dependências
- Monitoramento de performance

---

## 📈 Roadmap

### **Próximas Versões**
- [ ] Integração com gateways de pagamento
- [ ] App mobile (React Native)
- [ ] Sistema de afiliados
- [ ] Marketplace multi-vendor
- [ ] Integração com ERPs
- [ ] BI e Analytics avançados

---

## 📄 Licença

Este sistema foi desenvolvido especificamente para PDPrint. Todos os direitos reservados.

---

## 🎉 Conclusão

O **PDPrint** é uma solução completa e profissional para gestão de negócios de gráfica, malharia e identidade visual. Com arquitetura moderna, segurança robusta e interface intuitiva, oferece tudo que você precisa para digitalizar e otimizar seus processos.

**Desenvolvido com ❤️ para revolucionar sua gestão empresarial!**

