-- PDPrint + E-commerce - Estrutura de Banco MySQL
-- Versão: 1.0
-- Data: 2025-08-30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- TABELAS PRINCIPAIS DO SISTEMA
-- --------------------------------------------------------

-- Tabela de Usuários (Admin/Funcionários)
CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL UNIQUE,
  `senha` varchar(255) NOT NULL,
  `tipo` enum('super_admin','admin','gerente','vendedor','operador') NOT NULL DEFAULT 'operador',
  `franquia_id` int(11) DEFAULT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Franquias
CREATE TABLE `franquias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `cnpj` varchar(20) DEFAULT NULL,
  `endereco` text,
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `responsavel` varchar(100) DEFAULT NULL,
  `comissao_padrao` decimal(5,2) DEFAULT 10.00,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Categorias de Produtos
CREATE TABLE `categorias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `descricao` text,
  `slug` varchar(100) NOT NULL UNIQUE,
  `imagem` varchar(255) DEFAULT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `ordem` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Produtos
CREATE TABLE `produtos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(200) NOT NULL,
  `descricao` text,
  `descricao_curta` varchar(500) DEFAULT NULL,
  `slug` varchar(200) NOT NULL UNIQUE,
  `sku` varchar(50) DEFAULT NULL,
  `categoria_id` int(11) NOT NULL,
  `preco` decimal(10,2) NOT NULL DEFAULT 0.00,
  `preco_promocional` decimal(10,2) DEFAULT NULL,
  `custo` decimal(10,2) DEFAULT 0.00,
  `peso` decimal(8,3) DEFAULT NULL,
  `dimensoes` varchar(100) DEFAULT NULL,
  `imagem_principal` varchar(255) DEFAULT NULL,
  `galeria` text DEFAULT NULL,
  `estoque_minimo` int(11) DEFAULT 0,
  `controlar_estoque` tinyint(1) NOT NULL DEFAULT 1,
  `destaque` tinyint(1) NOT NULL DEFAULT 0,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `seo_title` varchar(200) DEFAULT NULL,
  `seo_description` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `categoria_id` (`categoria_id`),
  FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Estoque por Franquia
CREATE TABLE `estoque` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produto_id` int(11) NOT NULL,
  `franquia_id` int(11) NOT NULL,
  `quantidade` int(11) NOT NULL DEFAULT 0,
  `quantidade_reservada` int(11) NOT NULL DEFAULT 0,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `produto_franquia` (`produto_id`, `franquia_id`),
  KEY `produto_id` (`produto_id`),
  KEY `franquia_id` (`franquia_id`),
  FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Movimentações de Estoque
CREATE TABLE `movimentacoes_estoque` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produto_id` int(11) NOT NULL,
  `franquia_id` int(11) NOT NULL,
  `tipo` enum('entrada','saida','ajuste','transferencia') NOT NULL,
  `quantidade` int(11) NOT NULL,
  `motivo` varchar(200) DEFAULT NULL,
  `usuario_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `produto_id` (`produto_id`),
  KEY `franquia_id` (`franquia_id`),
  KEY `usuario_id` (`usuario_id`),
  FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`),
  FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- TABELAS DO E-COMMERCE
-- --------------------------------------------------------

-- Tabela de Clientes (E-commerce)
CREATE TABLE `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL UNIQUE,
  `senha` varchar(255) NOT NULL,
  `cpf` varchar(14) DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `data_nascimento` date DEFAULT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Endereços dos Clientes
CREATE TABLE `enderecos_clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `nome` varchar(50) NOT NULL DEFAULT 'Principal',
  `cep` varchar(10) NOT NULL,
  `endereco` varchar(200) NOT NULL,
  `numero` varchar(20) NOT NULL,
  `complemento` varchar(100) DEFAULT NULL,
  `bairro` varchar(100) NOT NULL,
  `cidade` varchar(100) NOT NULL,
  `estado` varchar(2) NOT NULL,
  `principal` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cliente_id` (`cliente_id`),
  FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Cupons de Desconto
CREATE TABLE `cupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) NOT NULL UNIQUE,
  `tipo` enum('percentual','valor_fixo') NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `valor_minimo` decimal(10,2) DEFAULT NULL,
  `limite_uso` int(11) DEFAULT NULL,
  `usado` int(11) NOT NULL DEFAULT 0,
  `data_inicio` datetime NOT NULL,
  `data_fim` datetime NOT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Pedidos
CREATE TABLE `pedidos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(20) NOT NULL UNIQUE,
  `cliente_id` int(11) NOT NULL,
  `franquia_id` int(11) NOT NULL,
  `status` enum('pendente','confirmado','preparando','enviado','entregue','cancelado') NOT NULL DEFAULT 'pendente',
  `subtotal` decimal(10,2) NOT NULL DEFAULT 0.00,
  `desconto` decimal(10,2) NOT NULL DEFAULT 0.00,
  `frete` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `cupom_id` int(11) DEFAULT NULL,
  `forma_pagamento` varchar(50) DEFAULT NULL,
  `status_pagamento` enum('pendente','aprovado','rejeitado','cancelado') NOT NULL DEFAULT 'pendente',
  `observacoes` text DEFAULT NULL,
  `endereco_entrega` text NOT NULL,
  `prazo_entrega` int(11) DEFAULT NULL,
  `codigo_rastreamento` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cliente_id` (`cliente_id`),
  KEY `franquia_id` (`franquia_id`),
  KEY `cupom_id` (`cupom_id`),
  FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`),
  FOREIGN KEY (`cupom_id`) REFERENCES `cupons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Itens do Pedido
CREATE TABLE `itens_pedido` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pedido_id` int(11) NOT NULL,
  `produto_id` int(11) NOT NULL,
  `quantidade` int(11) NOT NULL,
  `preco_unitario` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_id` (`pedido_id`),
  KEY `produto_id` (`produto_id`),
  FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- TABELAS DE PRODUÇÃO E CONTROLE
-- --------------------------------------------------------

-- Tabela de Ordens de Produção
CREATE TABLE `ordens_producao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(20) NOT NULL UNIQUE,
  `pedido_id` int(11) DEFAULT NULL,
  `franquia_id` int(11) NOT NULL,
  `produto_id` int(11) NOT NULL,
  `quantidade` int(11) NOT NULL,
  `status` enum('pendente','em_producao','concluida','cancelada') NOT NULL DEFAULT 'pendente',
  `data_inicio` datetime DEFAULT NULL,
  `data_conclusao` datetime DEFAULT NULL,
  `prazo` datetime DEFAULT NULL,
  `observacoes` text DEFAULT NULL,
  `responsavel_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pedido_id` (`pedido_id`),
  KEY `franquia_id` (`franquia_id`),
  KEY `produto_id` (`produto_id`),
  KEY `responsavel_id` (`responsavel_id`),
  FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`),
  FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`),
  FOREIGN KEY (`responsavel_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- TABELAS FINANCEIRAS
-- --------------------------------------------------------

-- Tabela de Contas a Receber
CREATE TABLE `contas_receber` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pedido_id` int(11) DEFAULT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `franquia_id` int(11) NOT NULL,
  `descricao` varchar(200) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `data_vencimento` date NOT NULL,
  `data_pagamento` date DEFAULT NULL,
  `status` enum('pendente','pago','vencido','cancelado') NOT NULL DEFAULT 'pendente',
  `forma_pagamento` varchar(50) DEFAULT NULL,
  `observacoes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pedido_id` (`pedido_id`),
  KEY `cliente_id` (`cliente_id`),
  KEY `franquia_id` (`franquia_id`),
  FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`),
  FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Contas a Pagar
CREATE TABLE `contas_pagar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `franquia_id` int(11) NOT NULL,
  `fornecedor` varchar(100) NOT NULL,
  `descricao` varchar(200) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `data_vencimento` date NOT NULL,
  `data_pagamento` date DEFAULT NULL,
  `status` enum('pendente','pago','vencido','cancelado') NOT NULL DEFAULT 'pendente',
  `categoria` varchar(50) DEFAULT NULL,
  `observacoes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `franquia_id` (`franquia_id`),
  FOREIGN KEY (`franquia_id`) REFERENCES `franquias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- TABELAS DE CONFIGURAÇÃO
-- --------------------------------------------------------

-- Tabela de Configurações do Sistema
CREATE TABLE `configuracoes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chave` varchar(100) NOT NULL UNIQUE,
  `valor` text DEFAULT NULL,
  `descricao` varchar(200) DEFAULT NULL,
  `tipo` enum('texto','numero','boolean','json') NOT NULL DEFAULT 'texto',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Logs do Sistema
CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `acao` varchar(100) NOT NULL,
  `tabela` varchar(50) DEFAULT NULL,
  `registro_id` int(11) DEFAULT NULL,
  `dados_anteriores` text DEFAULT NULL,
  `dados_novos` text DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- DADOS INICIAIS
-- --------------------------------------------------------

-- Inserir franquia padrão
INSERT INTO `franquias` (`id`, `nome`, `cnpj`, `endereco`, `telefone`, `email`, `responsavel`, `comissao_padrao`, `ativo`) VALUES
(1, 'PDPrint Matriz', '00.000.000/0001-00', 'Endereço da Matriz', '(11) 99999-9999', 'contato@pdprint.com.br', 'Administrador', 0.00, 1);

-- Inserir usuário super admin
INSERT INTO `usuarios` (`id`, `nome`, `email`, `senha`, `tipo`, `franquia_id`, `ativo`) VALUES
(1, 'Super Administrador', 'admin@pdprint.com.br', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'super_admin', 1, 1);

-- Inserir categorias padrão
INSERT INTO `categorias` (`nome`, `descricao`, `slug`, `ativo`, `ordem`) VALUES
('Gráfica', 'Produtos e serviços gráficos', 'grafica', 1, 1),
('Malharia', 'Produtos de malharia e confecção', 'malharia', 1, 2),
('Identidade Visual', 'Serviços de identidade visual e branding', 'identidade-visual', 1, 3);

-- Inserir configurações padrão
INSERT INTO `configuracoes` (`chave`, `valor`, `descricao`, `tipo`) VALUES
('site_nome', 'PDPrint', 'Nome do site', 'texto'),
('site_email', 'contato@pdprint.com.br', 'Email de contato', 'texto'),
('site_telefone', '(11) 99999-9999', 'Telefone de contato', 'texto'),
('frete_gratis_valor', '100.00', 'Valor mínimo para frete grátis', 'numero'),
('moeda', 'BRL', 'Moeda padrão', 'texto'),
('timezone', 'America/Sao_Paulo', 'Fuso horário', 'texto');

COMMIT;

