<?php
/**
 * PDPrint - Configurações do Sistema
 * Versão: 1.0
 * Data: 2025-08-30
 */

// Configurações de Erro
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configurações de Sessão
session_start();

// Configurações de Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'pdprint_db');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Configurações do Site
define('SITE_NAME', 'PDPrint');
define('SITE_URL', 'http://localhost');
define('ADMIN_URL', SITE_URL . '/admin');
define('LOJA_URL', SITE_URL . '/loja');
define('API_URL', SITE_URL . '/api');

// Configurações de Upload
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('UPLOAD_URL', SITE_URL . '/uploads/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB

// Configurações de Segurança
define('JWT_SECRET', 'pdprint_jwt_secret_key_2025');
define('HASH_ALGO', 'sha256');
define('SESSION_TIMEOUT', 3600); // 1 hora

// Configurações de Email
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'contato@pdprint.com.br');
define('SMTP_PASS', '');
define('SMTP_FROM', 'contato@pdprint.com.br');
define('SMTP_FROM_NAME', 'PDPrint');

// Configurações de Paginação
define('ITEMS_PER_PAGE', 20);

// Configurações de Moeda
define('CURRENCY', 'BRL');
define('CURRENCY_SYMBOL', 'R$');

// Autoload de Classes
spl_autoload_register(function ($class) {
    $file = __DIR__ . '/classes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// Funções Auxiliares
require_once __DIR__ . '/functions.php';

// Verificar se é uma requisição AJAX
function is_ajax() {
    return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
           strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
}

// Verificar se é uma requisição POST
function is_post() {
    return $_SERVER['REQUEST_METHOD'] === 'POST';
}

// Verificar se é uma requisição GET
function is_get() {
    return $_SERVER['REQUEST_METHOD'] === 'GET';
}

// Obter IP do cliente
function get_client_ip() {
    $ip_keys = ['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'];
    foreach ($ip_keys as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(',', $_SERVER[$key]) as $ip) {
                $ip = trim($ip);
                if (filter_var($ip, FILTER_VALIDATE_IP, 
                    FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    return $ip;
                }
            }
        }
    }
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

// Headers de Segurança
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

// CORS para API
if (strpos($_SERVER['REQUEST_URI'], '/api/') !== false) {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}
?>

