<?php
/**
 * PDPrint - Instalador Automático
 * Versão: 1.0
 */

// Verificar se já foi instalado
if (file_exists('includes/installed.lock')) {
    die('Sistema já foi instalado. Para reinstalar, delete o arquivo includes/installed.lock');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? 'pdprint_db';
    $db_user = $_POST['db_user'] ?? 'root';
    $db_pass = $_POST['db_pass'] ?? '';
    
    $admin_name = $_POST['admin_name'] ?? 'Administrador';
    $admin_email = $_POST['admin_email'] ?? 'admin@pdprint.com.br';
    $admin_password = $_POST['admin_password'] ?? 'admin123';
    
    $site_name = $_POST['site_name'] ?? 'PDPrint';
    $site_url = $_POST['site_url'] ?? 'http://localhost';
    
    try {
        // Conectar ao banco
        $pdo = new PDO("mysql:host={$db_host};charset=utf8mb4", $db_user, $db_pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Criar banco de dados se não existir
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$db_name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $pdo->exec("USE `{$db_name}`");
        
        // Executar SQL de criação das tabelas
        $sql = file_get_contents('database.sql');
        $pdo->exec($sql);
        
        // Atualizar dados do admin
        $admin_password_hash = password_hash($admin_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE usuarios SET nome = ?, email = ?, senha = ? WHERE id = 1");
        $stmt->execute([$admin_name, $admin_email, $admin_password_hash]);
        
        // Atualizar configurações do site
        $stmt = $pdo->prepare("UPDATE configuracoes SET valor = ? WHERE chave = 'site_nome'");
        $stmt->execute([$site_name]);
        
        // Criar arquivo de configuração
        $config_content = "<?php
// Configurações do Banco de Dados - Gerado automaticamente
define('DB_HOST', '{$db_host}');
define('DB_NAME', '{$db_name}');
define('DB_USER', '{$db_user}');
define('DB_PASS', '{$db_pass}');
define('DB_CHARSET', 'utf8mb4');

// Configurações do Site
define('SITE_NAME', '{$site_name}');
define('SITE_URL', '{$site_url}');
define('ADMIN_URL', SITE_URL . '/admin');
define('LOJA_URL', SITE_URL . '/loja');
define('API_URL', SITE_URL . '/api');
?>";
        
        file_put_contents('includes/db_config.php', $config_content);
        
        // Criar arquivo de lock
        file_put_contents('includes/installed.lock', date('Y-m-d H:i:s'));
        
        $success = 'Instalação concluída com sucesso!';
        
    } catch (Exception $e) {
        $error = 'Erro na instalação: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDPrint - Instalação</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 40px;
            width: 100%;
            max-width: 600px;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo h1 {
            color: #333;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .logo p {
            color: #666;
            font-size: 1.1rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-row {
            display: flex;
            gap: 15px;
        }
        
        .form-row .form-group {
            flex: 1;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: 500;
        }
        
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="url"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }
        
        .alert-success {
            background: #efe;
            color: #363;
            border: 1px solid #cfc;
        }
        
        .section-title {
            color: #333;
            font-size: 1.3rem;
            font-weight: 600;
            margin: 30px 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .success-actions {
            text-align: center;
            margin-top: 30px;
        }
        
        .success-actions a {
            display: inline-block;
            margin: 10px;
            padding: 12px 25px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            transition: background 0.3s;
        }
        
        .success-actions a:hover {
            background: #5a6fd8;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <h1>PDPrint</h1>
            <p>Instalação do Sistema</p>
        </div>
        
        <?php if ($error): ?>
            <div class="alert alert-error">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success">
                <?= htmlspecialchars($success) ?>
            </div>
            
            <div class="success-actions">
                <a href="admin/">Acessar Painel Admin</a>
                <a href="loja/">Acessar Loja</a>
            </div>
        <?php else: ?>
            <form method="POST">
                <div class="section-title">Configurações do Banco de Dados</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="db_host">Host do Banco</label>
                        <input type="text" id="db_host" name="db_host" value="localhost" required>
                    </div>
                    <div class="form-group">
                        <label for="db_name">Nome do Banco</label>
                        <input type="text" id="db_name" name="db_name" value="pdprint_db" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="db_user">Usuário</label>
                        <input type="text" id="db_user" name="db_user" value="root" required>
                    </div>
                    <div class="form-group">
                        <label for="db_pass">Senha</label>
                        <input type="password" id="db_pass" name="db_pass">
                    </div>
                </div>
                
                <div class="section-title">Configurações do Administrador</div>
                
                <div class="form-group">
                    <label for="admin_name">Nome do Administrador</label>
                    <input type="text" id="admin_name" name="admin_name" value="Administrador" required>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="admin_email">Email</label>
                        <input type="email" id="admin_email" name="admin_email" value="admin@pdprint.com.br" required>
                    </div>
                    <div class="form-group">
                        <label for="admin_password">Senha</label>
                        <input type="password" id="admin_password" name="admin_password" value="admin123" required>
                    </div>
                </div>
                
                <div class="section-title">Configurações do Site</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="site_name">Nome do Site</label>
                        <input type="text" id="site_name" name="site_name" value="PDPrint" required>
                    </div>
                    <div class="form-group">
                        <label for="site_url">URL do Site</label>
                        <input type="url" id="site_url" name="site_url" value="<?= 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) ?>" required>
                    </div>
                </div>
                
                <button type="submit" class="btn">Instalar PDPrint</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>

