<?php
/**
 * PDPrint Loja - Página Inicial
 */

require_once '../includes/config.php';

$db = new Database();

// Buscar produtos em destaque
$produtos_destaque = $db->select('produtos', ['destaque' => 1, 'ativo' => 1], '*', 'created_at DESC', 8);

// Buscar categorias ativas
$categorias = $db->select('categorias', ['ativo' => 1], '*', 'ordem ASC');

// Configurações do site
$config = [];
$config_data = $db->select('configuracoes');
foreach ($config_data as $item) {
    $config[$item['chave']] = $item['valor'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($config['site_nome'] ?? 'PDPrint') ?> - Gráfica, Malharia e Identidade Visual</title>
    <meta name="description" content="PDPrint - Sua parceira completa em gráfica, malharia e identidade visual. Produtos de qualidade com entrega rápida.">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        
        .header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-top {
            background: #667eea;
            color: white;
            padding: 10px 0;
            text-align: center;
            font-size: 14px;
        }
        
        .header-main {
            padding: 20px 0;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo h1 {
            color: #667eea;
            font-size: 2.5rem;
            font-weight: 700;
        }
        
        .header-actions {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .btn {
            background: #667eea;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .btn:hover {
            background: #5a6fd8;
        }
        
        .btn-outline {
            background: transparent;
            color: #667eea;
            border: 2px solid #667eea;
        }
        
        .btn-outline:hover {
            background: #667eea;
            color: white;
        }
        
        .nav {
            background: #f8fafc;
            padding: 15px 0;
        }
        
        .nav ul {
            list-style: none;
            display: flex;
            justify-content: center;
            gap: 40px;
        }
        
        .nav a {
            color: #333;
            text-decoration: none;
            font-weight: 500;
            padding: 10px 0;
            transition: color 0.3s;
        }
        
        .nav a:hover {
            color: #667eea;
        }
        
        .hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .hero h2 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .hero p {
            font-size: 1.3rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .hero-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }
        
        .btn-white {
            background: white;
            color: #667eea;
        }
        
        .btn-white:hover {
            background: #f8fafc;
        }
        
        .section {
            padding: 60px 0;
        }
        
        .section-title {
            text-align: center;
            margin-bottom: 50px;
        }
        
        .section-title h3 {
            font-size: 2.5rem;
            font-weight: 700;
            color: #333;
            margin-bottom: 15px;
        }
        
        .section-title p {
            font-size: 1.1rem;
            color: #666;
        }
        
        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }
        
        .category-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
            transition: transform 0.3s;
            text-decoration: none;
            color: inherit;
        }
        
        .category-card:hover {
            transform: translateY(-5px);
        }
        
        .category-image {
            height: 200px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 3rem;
        }
        
        .category-content {
            padding: 25px;
        }
        
        .category-content h4 {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 10px;
            color: #333;
        }
        
        .category-content p {
            color: #666;
            line-height: 1.6;
        }
        
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 30px;
        }
        
        .product-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            overflow: hidden;
            transition: transform 0.3s;
        }
        
        .product-card:hover {
            transform: translateY(-5px);
        }
        
        .product-image {
            height: 200px;
            background: #f8fafc;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ccc;
            font-size: 2rem;
        }
        
        .product-content {
            padding: 20px;
        }
        
        .product-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 10px;
            color: #333;
        }
        
        .product-price {
            font-size: 1.5rem;
            font-weight: 700;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .product-description {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
        
        .footer {
            background: #333;
            color: white;
            padding: 50px 0 20px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 30px;
        }
        
        .footer-section h4 {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 20px;
            color: #667eea;
        }
        
        .footer-section p,
        .footer-section a {
            color: #ccc;
            text-decoration: none;
            line-height: 1.8;
        }
        
        .footer-section a:hover {
            color: white;
        }
        
        .footer-bottom {
            border-top: 1px solid #555;
            padding-top: 20px;
            text-align: center;
            color: #999;
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 20px;
            }
            
            .nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .hero h2 {
                font-size: 2rem;
            }
            
            .hero-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .categories-grid,
            .products-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-top">
            <div class="container">
                Frete grátis para compras acima de <?= format_currency($config['frete_gratis_valor'] ?? 100) ?> | 
                Contato: <?= htmlspecialchars($config['site_telefone'] ?? '(11) 99999-9999') ?>
            </div>
        </div>
        
        <div class="header-main">
            <div class="container">
                <div class="header-content">
                    <div class="logo">
                        <h1><?= htmlspecialchars($config['site_nome'] ?? 'PDPrint') ?></h1>
                    </div>
                    
                    <div class="header-actions">
                        <a href="login.php" class="btn btn-outline">Entrar</a>
                        <a href="carrinho.php" class="btn">Carrinho (0)</a>
                        <a href="../admin/" class="btn btn-outline">Admin</a>
                    </div>
                </div>
            </div>
        </div>
        
        <nav class="nav">
            <div class="container">
                <ul>
                    <li><a href="index.php">Início</a></li>
                    <?php foreach ($categorias as $categoria): ?>
                    <li><a href="categoria.php?slug=<?= $categoria['slug'] ?>"><?= htmlspecialchars($categoria['nome']) ?></a></li>
                    <?php endforeach; ?>
                    <li><a href="contato.php">Contato</a></li>
                </ul>
            </div>
        </nav>
    </header>
    
    <main>
        <section class="hero">
            <div class="container">
                <h2>Sua Parceira Completa em Soluções Visuais</h2>
                <p>Gráfica, Malharia e Identidade Visual com qualidade e agilidade que seu negócio precisa</p>
                <div class="hero-buttons">
                    <a href="produtos.php" class="btn btn-white">Ver Produtos</a>
                    <a href="contato.php" class="btn">Solicitar Orçamento</a>
                </div>
            </div>
        </section>
        
        <section class="section">
            <div class="container">
                <div class="section-title">
                    <h3>Nossas Especialidades</h3>
                    <p>Soluções completas para todas as suas necessidades visuais</p>
                </div>
                
                <div class="categories-grid">
                    <?php foreach ($categorias as $categoria): ?>
                    <a href="categoria.php?slug=<?= $categoria['slug'] ?>" class="category-card">
                        <div class="category-image">
                            <?php
                            $icons = ['🖨️', '👕', '🎨'];
                            echo $icons[array_rand($icons)];
                            ?>
                        </div>
                        <div class="category-content">
                            <h4><?= htmlspecialchars($categoria['nome']) ?></h4>
                            <p><?= htmlspecialchars($categoria['descricao']) ?></p>
                        </div>
                    </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        
        <?php if (!empty($produtos_destaque)): ?>
        <section class="section" style="background: #f8fafc;">
            <div class="container">
                <div class="section-title">
                    <h3>Produtos em Destaque</h3>
                    <p>Confira nossos produtos mais procurados</p>
                </div>
                
                <div class="products-grid">
                    <?php foreach ($produtos_destaque as $produto): ?>
                    <div class="product-card">
                        <div class="product-image">
                            <?php if ($produto['imagem_principal']): ?>
                                <img src="<?= UPLOAD_URL . $produto['imagem_principal'] ?>" alt="<?= htmlspecialchars($produto['nome']) ?>" style="width: 100%; height: 100%; object-fit: cover;">
                            <?php else: ?>
                                📦
                            <?php endif; ?>
                        </div>
                        <div class="product-content">
                            <div class="product-title"><?= htmlspecialchars($produto['nome']) ?></div>
                            <div class="product-price">
                                <?php if ($produto['preco_promocional']): ?>
                                    <span style="text-decoration: line-through; color: #999; font-size: 1rem;"><?= format_currency($produto['preco']) ?></span>
                                    <?= format_currency($produto['preco_promocional']) ?>
                                <?php else: ?>
                                    <?= format_currency($produto['preco']) ?>
                                <?php endif; ?>
                            </div>
                            <?php if ($produto['descricao_curta']): ?>
                            <div class="product-description"><?= htmlspecialchars($produto['descricao_curta']) ?></div>
                            <?php endif; ?>
                            <a href="produto.php?slug=<?= $produto['slug'] ?>" class="btn" style="width: 100%; text-align: center;">Ver Detalhes</a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php endif; ?>
    </main>
    
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h4><?= htmlspecialchars($config['site_nome'] ?? 'PDPrint') ?></h4>
                    <p>Sua parceira completa em gráfica, malharia e identidade visual. Qualidade, agilidade e preço justo.</p>
                </div>
                
                <div class="footer-section">
                    <h4>Contato</h4>
                    <p>Email: <?= htmlspecialchars($config['site_email'] ?? 'contato@pdprint.com.br') ?></p>
                    <p>Telefone: <?= htmlspecialchars($config['site_telefone'] ?? '(11) 99999-9999') ?></p>
                </div>
                
                <div class="footer-section">
                    <h4>Categorias</h4>
                    <?php foreach ($categorias as $categoria): ?>
                    <p><a href="categoria.php?slug=<?= $categoria['slug'] ?>"><?= htmlspecialchars($categoria['nome']) ?></a></p>
                    <?php endforeach; ?>
                </div>
                
                <div class="footer-section">
                    <h4>Links Úteis</h4>
                    <p><a href="sobre.php">Sobre Nós</a></p>
                    <p><a href="contato.php">Contato</a></p>
                    <p><a href="politica-privacidade.php">Política de Privacidade</a></p>
                    <p><a href="termos-uso.php">Termos de Uso</a></p>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> <?= htmlspecialchars($config['site_nome'] ?? 'PDPrint') ?>. Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>
</body>
</html>

